if (!window.Preview) {
  var Preview = {};
}

/**
 * Namespace for preview manipulation methods
 * @namespace Preview.view
 * @memberof  Preview
 */
Preview.view = (function() {

  /**
   * Run all methods that update the preview
   */
  const parse = () => {
    if (shouldWikiLink) {
      Preview.view.wikiLink();
    }
    if (shouldHighlight) {
      document.querySelectorAll('pre code').forEach((block) => {
        hljs.highlightBlock(block);
      });
    }
    if (shouldRenderMath) {
      renderMathInElement(document.body);
    }
  }

  /**
   * Replace [[wiki links]] in text with url handler search links
   * @alias  wikiLink
   */
  const wikiLink = () => {
    const container = document.querySelector("body");

    const replacer = (match, p1, p2, offset, string) => {
      let str = p2,
        after = '';

      // if the scroll point marker is inside of our double brackets, remove and
      // re-insert at the end.
      if (/<a id="MMDHTMLSCROLLPOINT".*?\/a>/i.test(str)) {
        str = str.replace(/<a id="MMDHTMLSCROLLPOINT".*?\/a>/, '');
        after = '<a id="MMDHTMLSCROLLPOINT" style="font-size:0px;position:absolute;left:10px;">.</a>';
      }
      return `<a class="wikilink" href=\'x-nvultra://wiki/?link=${encodeURIComponent(str)}\'>${str}</a>${after}`;
    }

    container.innerHTML = container.innerHTML.replace(
      /(\[\[(.*?)\]\])(?!<\/a)/g,
      replacer
    );
  }

  return {
    // methods
    parse,
    wikiLink
  };
})();

document.addEventListener("DOMContentLoaded", function(event) {
  Preview.view.parse();
});
